package game;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;

import javax.swing.ImageIcon;
import javax.swing.JOptionPane;


public class RoomData {
	
//	private ArrayList<SolidBlockSprite> rogueBlocks;
	private ArrayList<RogueBlockSpawnPoint> rogueBlockData;
	private StaticBlockManager blockManager;
	private String roomName;
//	private int playerSpawnPointX;
//	private int playerSpawnPointY;
	
	private Color backgroundColor = Color.black;
	
	private ArrayList<EnemySpawnPoint> enemySpawnPoints;
	private ArrayList<DoorSprite> doors;
	private ArrayList<DoorSprite> commentDoors;
	
	private ArrayList<ItemSpawnPoint> itemSpawnPoints;
	
	private BossSpawnPoint bossSpawnPoint;
	
	private ArrayList<WidgetSprite> backgroundWidgets;
	private ArrayList<WidgetSprite> foregroundWidgets;
	private ArrayList<WidgetSprite> commentWidgets;
	
	private GoalSprite goal;
	
	private ArrayList<RadioSprite> radios;
	
	private ArrayList<HurtzoneSprite> hurtzones;
	
	private LevelData parent;
	
	public RoomData(int dummy, String fileToLoad, LevelData levelData, PonyPanel ponyPanel, boolean fromFiles) {
		
		parent = levelData;
		
		BufferedReader in = null;
		
		try {
			
			blockManager = new StaticBlockManager();
//			rogueBlocks = new ArrayList<SolidBlockSprite>();
			rogueBlockData = new ArrayList<RogueBlockSpawnPoint>();
			enemySpawnPoints = new ArrayList<EnemySpawnPoint>();
			doors = new ArrayList<DoorSprite>();
			commentDoors = new ArrayList<DoorSprite>();
			itemSpawnPoints = new ArrayList<ItemSpawnPoint>();
			backgroundWidgets = new ArrayList<WidgetSprite>();
			foregroundWidgets = new ArrayList<WidgetSprite>();
			commentWidgets = new ArrayList<WidgetSprite>();
			radios = new ArrayList<RadioSprite>();
			hurtzones = new ArrayList<HurtzoneSprite>();
			
			EnemySpawnPoint enemySpawnPoint = null;
			
			if(fromFiles) {
				in = new BufferedReader(new FileReader(fileToLoad));
			} else {
				URL url = LevelData.class.getResource(fileToLoad);
				in = new BufferedReader(new InputStreamReader(url.openStream()));
			}
			
			String inputter = null;
			
			while((inputter = in.readLine()) != null) {
				
				if(inputter.contains("#"))
					continue;
				
				if(inputter.contains("roomName:")) {
					roomName = inputter.substring(9);
				} else if(inputter.contains("bgColor:")) {
					backgroundColor = CustomImageData.translateFileInStringToColor(inputter.substring(8).trim());
//				} else if(inputter.contains("defaultPlayerSpawnX:")) {
//					playerSpawnPointX = Integer.parseInt(inputter.substring(20).trim());
//				} else if(inputter.contains("defaultPlayerSpawnY:")) {
//					playerSpawnPointY = Integer.parseInt(inputter.substring(20).trim());
				} else if(inputter.contains("staticBlocks")) {
//					System.out.println("ABOUT TO LOAD UP DUMMYROOM!!!  [" + roomName + "]");
					blockManager.readFromFile(in, fileToLoad, "ROOM NAME [" + roomName + "]", ponyPanel, fromFiles);
//					System.out.println("JUST LOADED UP DUMMYROOM!!!");
//					blockManager.printAllColumnSizes();
//					System.out.println("YES JUST LOADED UP DUMMYROOM!!!");
				} else if(inputter.contains("enemy")) {
//					System.out.println("<><>DELME now in enemy!");
					enemySpawnPoint = EnemySpawnPoint.readFromReader(in);
					if(enemySpawnPoint != null)
						enemySpawnPoints.add(enemySpawnPoint);
//					else 
//						System.out.println("<><>DELME  ------------------------------it was null!");
				} else if(inputter.contains("block")) {
					
					RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readNonMovingBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
					if(rbsp != null)
						rogueBlockData.add(rbsp);
					
//					SolidBlockSprite sbs = populateRogueBlock(in);
//					if(sbs != null) {
//						rogueBlocks.add(sbs);
//					}
					
				} else if(inputter.contains("movingBlock")) {
					
					RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readMovingBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
					if(rbsp != null)
						rogueBlockData.add(rbsp);
					
//					MovingBlockSprite mbs = populateMovingBlock(in);
//					if(mbs != null) {
//						rogueBlocks.add(mbs);
//					}
					
				} else if(inputter.contains("comment_door")) {
					DoorSprite door = new DoorSprite(in, levelData, ponyPanel, fromFiles);
					commentDoors.add(door);
				} else if(inputter.contains("door")) {
					DoorSprite door = new DoorSprite(in, levelData, ponyPanel, fromFiles);
					doors.add(door);
				} else if(inputter.contains("item:")) {
					ItemSpawnPoint isp = ItemSpawnPoint.readFromFile(in);
					itemSpawnPoints.add(isp);
				} else if(inputter.contains("bgwidget:")) {
					WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
					backgroundWidgets.add(ws);
				} else if(inputter.contains("fgwidget:")) {
					WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
					foregroundWidgets.add(ws);
				} else if(inputter.contains("commentWidget:")) {
					WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
					commentWidgets.add(ws);
				} else if(inputter.contains("goal:")) {
					goal = GoalSprite.readFromFile(in, ponyPanel, fromFiles, roomName);
				} else if(inputter.contains("radio:" )) {
					RadioSprite radio = RadioSprite.readFromFile(in, ponyPanel, fromFiles);
					radios.add(radio);
				} else if(inputter.contains("hurtzone:")) {
					HurtzoneSprite hurtzone = new HurtzoneSprite(in);
					hurtzones.add(hurtzone);
				}
				
			}
			
			
			
		} catch (Exception e) {
			// TODO Auto-generated catch block
//			e.printStackTrace();
			
			JOptionPane.showMessageDialog(null, "Error occurred while trying to load a room: " + e.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
			
		} finally {
			try {in.close();} catch(Exception e) {}
		}
		
		
	}

	public ArrayList<SolidBlockSprite> getRogueBlocks() {
		
		ArrayList<SolidBlockSprite> returnValue = new ArrayList<SolidBlockSprite>();
		
		for(int i = 0; i < rogueBlockData.size(); i++) {
			returnValue.add(rogueBlockData.get(i).createBlock());
		}
		
		return returnValue;
	}

	public ArrayList<RogueBlockSpawnPoint> getRogueBlockData() {
		return rogueBlockData;
	}
	
	public StaticBlockManager getBlockManager() {
		return blockManager;
	}

	public String getRoomName() {
		return roomName;
	}

//	public int getPlayerSpawnPointX() {
//		return playerSpawnPointX;
//	}
//
//	public int getPlayerSpawnPointY() {
//		return playerSpawnPointY;
//	}

	public ArrayList<EnemySpawnPoint> getEnemySpawnPoints() {
		return enemySpawnPoints;
	}
	
	public Color getBackgroundColor() {
		return backgroundColor;
	}
	
	public void primeAll(Graphics g) {
		
		blockManager.primeAllImages(g);
		
//		SolidBlockSprite block = null;
//		
//		for(int i = 0; i < rogueBlocks.size(); i++) {
//			block = rogueBlocks.get(i);
//			block.primeImage(g);
//		}
		
		 RogueBlockSpawnPoint rbsp = null;
		 
		 for(int i = 0; i < rogueBlockData.size(); i++) {
			 rbsp = rogueBlockData.get(i);
			 rbsp.primeAll(g);
		 }
		
		
		
	}
	
	
	private BlockInterface populateRogueBlock(BufferedReader in, PonyPanel ponyPanel) throws IOException {
		
		String imageFile = null;
		int width = -1;
		int height = -1;
		int xPos = -1;
		int yPos = -1;
		Boolean passThru = null;
		Color transparentColor = null;

		String inputter = null;
		
		try {
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
					xPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					yPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
					width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
					height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("solid")) {
					passThru = false;
				} else if(inputter.contains("passThru")) {
					passThru = true;
				} else if(inputter.contains("graphic:")) {
					imageFile = inputter.substring(8).trim();
				} else if(inputter.contains("transparent:")) {
					transparentColor = CustomImageData.translateFileInStringToColor(inputter.substring(12));
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file, but it didn't find one.<br>This from line: "+inputter+"</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(xPos == -1 || yPos == -1 || imageFile == null || passThru == null || width == -1 || height == -1) {
			return null;
		}
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.out.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
//		
//		ImageIcon ii = new ImageIcon(url);
//		CustomImageData cid = new CustomImageData(ii.getImage(), width, height, transparentColor, ponyPanel);
		CustomImageDataII cid = new CustomImageDataII("/images/" + imageFile + ".GIF", transparentColor, ponyPanel);
		
		BlockInterface returnValue = new SolidBlockSprite(cid, width, height, xPos, yPos, passThru);
		
		
		return returnValue;
		
	}
	
	
	private MovingBlockSprite populateMovingBlock(BufferedReader in, PonyPanel ponyPanel) throws IOException {
		
		String imageFile = null;
		int width = -1;
		int height = -1;
		int xPos = -1;
		int yPos = -1;
		Boolean passThru = null;
		Color transparentColor = null;
		int minX = -1;
		int minY = -1;
		int maxX = -1;
		int maxY = -1;
		boolean isVertical = false;
		boolean isHorizontal = false;
		int moveSpeed = -1;
		char initDir = '\0';
		String name = null;

		String inputter = null;
		
		try {
			
			while ((inputter = in.readLine()) != null) {
				
				if(inputter.contains("/block")) {
					break;
				} else if(inputter.contains("x:")) {
					xPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("y:")) {
					yPos = Integer.parseInt(inputter.substring(2).trim());
				} else if(inputter.contains("width:")) {
					width = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("height:")) {
					height = Integer.parseInt(inputter.substring(7).trim());
				} else if(inputter.contains("solid")) {
					passThru = false;
				} else if(inputter.contains("passThru")) {
					passThru = true;
				} else if(inputter.contains("graphic:")) {
					imageFile = inputter.substring(8).trim();
				} else if(inputter.contains("transparent:")) {
					transparentColor = CustomImageData.translateFileInStringToColor(inputter.substring(12));
				} else if(inputter.contains("minX:")) {
					minX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("maxX:")) {
					maxX = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("minY:")) {
					minY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("maxY:")) {
					maxY = Integer.parseInt(inputter.substring(5).trim());
				} else if(inputter.contains("speed:")) {
					moveSpeed = Integer.parseInt(inputter.substring(6).trim());
				} else if(inputter.contains("horizontal")) {
					isHorizontal = true;
				} else if(inputter.contains("vertical")) {
					isVertical = true;
				} else if(inputter.contains("dir:")) {
					initDir = inputter.charAt(4);
				} else if(inputter.contains("/movingBlock"))
					break;
				else if(inputter.contains("name:")) {
					name = inputter.substring(5);
				}
				
			}
		} catch(IndexOutOfBoundsException ioobe) {
//			ioobe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  a line in the file wasn't long enough: <br>"+inputter+".</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		} catch(NumberFormatException mfe) {
//			mfe.printStackTrace();
			JOptionPane.showMessageDialog(null, "<html>Error:  the computer was expecting a number in the<br>file, but it didn't find one.<br>This from line: "+inputter+"</html>","Error", JOptionPane.ERROR_MESSAGE);
			return null;
		}
		
		if(xPos == -1 || yPos == -1 || imageFile == null || passThru == null || width == -1 || height == -1) {
//			System.err.println("something was null!  xPos, yPos, imageFile, passThry, width, or height");
			return null;
		}
		
		if(isHorizontal) {
			if(minX == -1 || maxX == -1) {
//				System.err.println("minX or maxX was null!");
				return null;
			}
		} else if(isVertical) {
			if(minY == -1 || maxY == -1) {
//				System.err.println("minY or maxY was null!");
				return null;
			}
		} else {
//			System.err.println("both isHorizontal and isVertical were null!");
			return null;
		}
		
		if(moveSpeed == -1) {
//			System.err.println("moveSpeed was null!");
			return null;
		}
		
//		URL url = RoomData.class.getResource("images/" + imageFile + ".GIF");
//		
//		if(url == null) {
//			System.err.println("count not find " + "images/" + imageFile + ".GIF");
//			return null;
//		}
//		
//		ImageIcon ii = new ImageIcon(url);
//		CustomImageData cid = new CustomImageData(ii.getImage(), width, height, transparentColor, ponyPanel);
		CustomImageDataII cid = new CustomImageDataII("/images/" + imageFile + ".GIF", transparentColor, ponyPanel);
		
		if(isHorizontal) {
			MovingBlockSprite returnValue = new MovingBlockSprite(cid, width, height, xPos, yPos, passThru,
					MovingBlockSprite.MOVE_MODE_EAST_WEST, minX, maxX, initDir, moveSpeed, name);
			
			
			return returnValue;
		} else if(isVertical) {
			MovingBlockSprite returnValue = new MovingBlockSprite(cid, width, height, xPos, yPos, passThru,
					MovingBlockSprite.MOVE_MODE_NORTH_SOUTH, minY, maxY, initDir, moveSpeed, name);
			
			
			return returnValue;
		} else {
//			System.err.println("how did we even get here?");
			return null;
		}
		
	}
	
	

	public RoomData(BufferedReader in, String fileToLoad, LevelData level, PonyPanel ponyPanel, boolean fromFiles) throws Exception {
		
		
		parent = level;
		blockManager = new StaticBlockManager();
//		rogueBlocks = new ArrayList<SolidBlockSprite>();
		rogueBlockData = new ArrayList<RogueBlockSpawnPoint>();
		enemySpawnPoints = new ArrayList<EnemySpawnPoint>();
		doors = new ArrayList<DoorSprite>();
		commentDoors = new ArrayList<DoorSprite>();
		itemSpawnPoints = new ArrayList<ItemSpawnPoint>();
		backgroundWidgets = new ArrayList<WidgetSprite>();
		foregroundWidgets = new ArrayList<WidgetSprite>();
		commentWidgets = new ArrayList<WidgetSprite>();
		radios = new ArrayList<RadioSprite>();
		hurtzones = new ArrayList<HurtzoneSprite>();
		
		goal = null;
		
		EnemySpawnPoint enemySpawnPoint = null;
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			
			if(inputter.contains("roomName:")) {
				roomName = inputter.substring(9);
			} else if(inputter.contains("bgColor:")) {
				backgroundColor = CustomImageData.translateFileInStringToColor(inputter.substring(8).trim());
//				System.out.println("got the bg color");
//			} else if(inputter.contains("defaultPlayerSpawnX:")) {
//				playerSpawnPointX = Integer.parseInt(inputter.substring(20).trim());
//				System.out.println("got the default player spawn X");
//			} else if(inputter.contains("defaultPlayerSpawnY:")) {
//				playerSpawnPointY = Integer.parseInt(inputter.substring(20).trim());
//				System.out.println("got the default player spawn Y");
			} else if(inputter.contains("staticBlocks") && !inputter.contains("/staticBlocks")) {
//				System.out.println("about to load up the blockManager...this from level: " + level.getName() + ", room name: " + roomName);
				blockManager.readFromFile(in, fileToLoad, roomName, ponyPanel, fromFiles);
//				System.out.println("blockManager load complete.  We'll see how it went...");
			} else if(inputter.contains("enemy")) {
//				System.out.println("<><>DELME now in enemy!");
				enemySpawnPoint = EnemySpawnPoint.readFromReader(in);
				if(enemySpawnPoint != null)
					enemySpawnPoints.add(enemySpawnPoint);
//				else 
//					System.out.println("<><>DELME  ------------------------------it was null!");
			} else if(inputter.contains("block")) {
				
				RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readNonMovingBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
				rogueBlockData.add(rbsp);
				
//				SolidBlockSprite sbs = populateRogueBlock(in);
//				if(sbs != null) {
//					rogueBlocks.add(sbs);
//				}
				
			} else if(inputter.contains("movingBlock")) {
				
				RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readMovingBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
				rogueBlockData.add(rbsp);
				
//				MovingBlockSprite mbs = populateMovingBlock(in);
//				if(mbs != null) {
//					rogueBlocks.add(mbs);
//				}
				
			} else if(inputter.contains("conveyor")) {
				
				RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readConveyorBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
				rogueBlockData.add(rbsp);
				
			} else if(inputter.contains("/room")) {
//				System.out.println("read the end of the room.  We should be good...");
				return;
			} else if(inputter.contains("comment_door")) {
				DoorSprite door = new DoorSprite(in, level, ponyPanel, fromFiles);
				commentDoors.add(door);
			} else if(inputter.contains("door")) {
				DoorSprite door = new DoorSprite(in, level, ponyPanel, fromFiles);
				doors.add(door);
			} else if(inputter.contains("item:")) {
				ItemSpawnPoint isp = ItemSpawnPoint.readFromFile(in);
				itemSpawnPoints.add(isp);
			} else if(inputter.contains("boss:")) {
				bossSpawnPoint = BossSpawnPoint.readFromFile(in);
			} else if(inputter.contains("bgwidget:")) {
				WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
				backgroundWidgets.add(ws);
			} else if(inputter.contains("fgwidget:")) {
				WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
				foregroundWidgets.add(ws);
			} else if(inputter.contains("commentWidget:")) {
				WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
				commentWidgets.add(ws);
			} else if(inputter.contains("goal:")) {
				goal = GoalSprite.readFromFile(in, ponyPanel, fromFiles, roomName);
			} else if(inputter.contains("radio:" )) {
				RadioSprite radio = RadioSprite.readFromFile(in, ponyPanel, fromFiles);
				radios.add(radio);
			} else if(inputter.contains("hurtzone:")) {
				HurtzoneSprite hurtzone = new HurtzoneSprite(in);
				hurtzones.add(hurtzone);
			} else if(inputter.contains("portaNoCompleta")) {
				handlePortaNoCompleta(in);
			}
			
		}
		
			
			
		
		
		
	}

	public ArrayList<DoorSprite> getDoors() {
		return doors;
	}
	
	public ArrayList<DoorSprite> getCommentDoors() {
		return commentDoors;
	}
	
	public ArrayList<ItemSpawnPoint> getItemSpawnPoints() {
		return itemSpawnPoints;
	}
	
	public BossSpawnPoint getBossSpawnPoint() {
		return bossSpawnPoint;
	}
	
	public ArrayList<WidgetSprite> getBackgroundWidgets() {
		return backgroundWidgets;
	}
	
	public ArrayList<WidgetSprite> getForegroundWidgets() {
		return foregroundWidgets;
	}
	
	public ArrayList<WidgetSprite> getCommentWidgets() {
		return commentWidgets;
	}
	
	public GoalSprite getGoal() {
		return goal;
	}

	public ArrayList<RadioSprite> getRadios() {
		return radios;
	}
	
	public ArrayList<HurtzoneSprite> getHurtzones() {
		return hurtzones;
	}
	
	
	public static void handlePortaNoCompleta(BufferedReader in) throws IOException{
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("/portaNoCompleta"))
				return;
			
		}
		
	}
	
	
	
	
	public static boolean retrieveFileLengths(BufferedReader in, String fileToLoad, LevelData level, PonyPanel ponyPanel, boolean fromFiles, HashMap<String, Long> fileLengths) throws Exception {
		
		
		
//		blockManager = new StaticBlockManager();
////		rogueBlocks = new ArrayList<SolidBlockSprite>();
//		rogueBlockData = new ArrayList<RogueBlockSpawnPoint>();
//		enemySpawnPoints = new ArrayList<EnemySpawnPoint>();
//		doors = new ArrayList<DoorSprite>();
//		commentDoors = new ArrayList<DoorSprite>();
//		itemSpawnPoints = new ArrayList<ItemSpawnPoint>();
//		backgroundWidgets = new ArrayList<WidgetSprite>();
//		foregroundWidgets = new ArrayList<WidgetSprite>();
//		commentWidgets = new ArrayList<WidgetSprite>();
//		radios = new ArrayList<RadioSprite>();
//		hurtzones = new ArrayList<HurtzoneSprite>();
//		
//		goal = null;
		
		EnemySpawnPoint enemySpawnPoint = null;
		
		String inputter = null;
		
		while((inputter = in.readLine()) != null) {
			
			if(inputter.contains("#"))
				continue;
			
			if(inputter.contains("roomName:")) {
//				roomName = inputter.substring(9);
			} else if(inputter.contains("music:")) {
				
				if(inputter.equalsIgnoreCase("music:nomusic") || inputter.equalsIgnoreCase("music:default"))
					continue;
				
				FileInputStream fis = new FileInputStream(inputter.substring(6).trim());
				
				long lengthOfFile = 0L;
				
				while(fis.read() != -1)
					lengthOfFile++;
				
				fis.close();
				
				fileLengths.put(inputter.substring(6).trim(), lengthOfFile);
				
				
			} else if(inputter.contains("bgColor:")) {
//				backgroundColor = CustomImageData.translateFileInStringToColor(inputter.substring(8).trim());
//				System.out.println("got the bg color");
//			} else if(inputter.contains("defaultPlayerSpawnX:")) {
//				playerSpawnPointX = Integer.parseInt(inputter.substring(20).trim());
//				System.out.println("got the default player spawn X");
//			} else if(inputter.contains("defaultPlayerSpawnY:")) {
//				playerSpawnPointY = Integer.parseInt(inputter.substring(20).trim());
//				System.out.println("got the default player spawn Y");
			} else if(inputter.contains("staticBlocks") && !inputter.contains("/staticBlocks")) {
				
				//load up static block data
				StaticBlockManager.retrieveFileLengths(in, null, null, null, false, fileLengths);
				
//				System.out.println("about to load up the blockManager...this from level: " + level.getName() + ", room name: " + roomName);
//				blockManager.readFromFile(in, fileToLoad, roomName, ponyPanel, fromFiles);
//				System.out.println("blockManager load complete.  We'll see how it went...");
			} else if(inputter.contains("enemy")) {
//				System.out.println("<><>DELME now in enemy!");
//				enemySpawnPoint = EnemySpawnPoint.readFromReader(in);
//				if(enemySpawnPoint != null)
//					enemySpawnPoints.add(enemySpawnPoint);
//				else 
//					System.out.println("<><>DELME  ------------------------------it was null!");
			} else if(inputter.contains("block")) {
				
				//load up rogue block data
				
				RogueBlockSpawnPoint.retrieveFileLengthsNonMovingBlock(in, null, true, null, fileLengths);
				
//				RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readNonMovingBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
//				rogueBlockData.add(rbsp);
				
//				SolidBlockSprite sbs = populateRogueBlock(in);
//				if(sbs != null) {
//					rogueBlocks.add(sbs);
//				}
				
			} else if(inputter.contains("movingBlock")) {
				
				RogueBlockSpawnPoint.retrieveFileLengthsMovingBlock(in, null, true, null, fileLengths);
				
				//load up moving block data
				
//				RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readMovingBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
//				rogueBlockData.add(rbsp);
				
//				MovingBlockSprite mbs = populateMovingBlock(in);
//				if(mbs != null) {
//					rogueBlocks.add(mbs);
//				}
				
			} else if(inputter.contains("conveyor")) {
				
				RogueBlockSpawnPoint.retrieveFileLengthsConveyor(in, null, false, null, fileLengths);
				
				
				
				//load up conveyor data
				
//				RogueBlockSpawnPoint rbsp = RogueBlockSpawnPoint.readConveyorBlockDataFromFile(in, ponyPanel, fromFiles, roomName);
//				rogueBlockData.add(rbsp);
				
			} else if(inputter.contains("/room")) {
//				System.out.println("read the end of the room.  We should be good...");
				return true;
			} else if(inputter.contains("comment_door")) {
				
				//load up door data
				
				DoorSprite.retrieveFileLengths(in, null, null, false, fileLengths);
				
//				DoorSprite door = new DoorSprite(in, level, ponyPanel, fromFiles);
//				commentDoors.add(door);
			} else if(inputter.contains("door")) {
				

				//load up door data

				DoorSprite.retrieveFileLengths(in, null, null, false, fileLengths);
				
//				DoorSprite door = new DoorSprite(in, level, ponyPanel, fromFiles);
//				doors.add(door);
			} else if(inputter.contains("item:")) {
//				ItemSpawnPoint isp = ItemSpawnPoint.readFromFile(in);
//				itemSpawnPoints.add(isp);
			} else if(inputter.contains("boss:")) {
//				bossSpawnPoint = BossSpawnPoint.readFromFile(in);
			} else if(inputter.contains("bgwidget:")) {
				
				//load up widget data
				
				WidgetSprite.retrieveFileLengths(in, null, false, null, fileLengths);
				
//				WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
//				backgroundWidgets.add(ws);
			} else if(inputter.contains("fgwidget:")) {

				//load up widget data

				WidgetSprite.retrieveFileLengths(in, null, false, null, fileLengths);
				
//				WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
//				foregroundWidgets.add(ws);
			} else if(inputter.contains("commentWidget:")) {

				//load up widget data

				WidgetSprite.retrieveFileLengths(in, null, false, null, fileLengths);
				
//				WidgetSprite ws = new WidgetSprite(in, ponyPanel, fromFiles, roomName);
//				commentWidgets.add(ws);
			} else if(inputter.contains("goal:")) {

				//load up goal data
				
				GoalSprite.retrieveFileLengths(in, null, false, null, fileLengths);
				
//				goal = GoalSprite.readFromFile(in, ponyPanel, fromFiles, roomName);
			} else if(inputter.contains("radio:" )) {

				//load up radio data
				
				RadioSprite.retrieveFileLengths(in, null, false, fileLengths);
				
//				RadioSprite radio = RadioSprite.readFromFile(in, ponyPanel, fromFiles);
//				radios.add(radio);
			} else if(inputter.contains("hurtzone:")) {
//				HurtzoneSprite hurtzone = new HurtzoneSprite(in);
//				hurtzones.add(hurtzone);
			} else if(inputter.contains("portaNoCompleta")) {
				handlePortaNoCompleta(in);
			}
			
		}
		
			
			
		
		return inputter != null;
		
	}
	
	public LevelData getParent() {
		return parent;
	}
	
	public void purgeAudio() {
		if(radios == null)
			return;
		
		for(RadioSprite r : radios) {
			r.purgeAudio();
		}
	}
	
	public void loadAudio() {
		
		if(radios == null) {
			System.out.println("<><>DELME radios is null!");
			return;
		}
		
		
		
		for(RadioSprite r : radios) {
			r.loadUpAudio();
		}
	}
	
	public boolean connectsTo(RoomData other) {
		
		if(doors == null)
			return false;
		
		for(DoorSprite d : doors) {
			if(d.getDestinationRoom().getRoomName().equalsIgnoreCase(other.getRoomName()))
				return true;
		}
		
		return false;
	}
	
	public boolean connectsTo(String otherName) {
		
		if(doors == null)
			return false;
		
		for(DoorSprite d : doors) {
			if(d.getDestinationRoom().getRoomName().equalsIgnoreCase(otherName))
				return true;
		}
		
		return false;
	}
	
}
